CP1251

var version = java.lang.System.getProperty("java.version");
if (version.startsWith("1.8.0")) {
    load("nashorn:mozilla_compat.js");
}

importPackage(java.io);
importPackage(org.apache.poi.hssf.usermodel);
importPackage(org.apache.poi.hssf.util);
importPackage(org.apache.log4j);

logger = LogManager.getLogger('Logger');

//      

grid = SELF.getAliases().get(GLOBAL.get('GRID_NAME'));

if (grid == null)
{
  logger.debug('Can\'t find grid ' + GLOBAL.get('GRID_NAME'));
  shit.happens();
}

/*
d1 = 1;
d2 = java.lang.Integer(1);
logger.debug('d1 type: ' + typeof(d1));
if (typeof(d1) == 'object') logger.debug('d1 class: ' + d1.getClass());
else logger.debug('d1 type: ' + typeof(d1));
if (typeof(d2) == 'object') logger.debug('d2 class: ' + d2.getClass());
else logger.debug('d2 type: ' + typeof(d2));
d1 = d1 + 1.56;
if (typeof(d1) == 'object') logger.debug('d1 class: ' + d1.getClass());
else logger.debug('d1 type: ' + typeof(d1));

logger.debug('d1: [' + d1 + '], d2: [' + d2+ ']');
*/

wb = new HSSFWorkbook();

sheet = wb.createSheet('_');
ps = sheet.getPrintSetup();
sheet.setAutobreaks(true);
ps.setFitHeight(1000);
ps.setFitWidth(1);

font = wb.createFont();
font.setFontHeightInPoints(12);
font.setFontName("Arial");
//font.setItalic(true);
//font.setStrikeout(true);


//  <   c >,     
style1 = wb.createCellStyle();
style1.setBorderBottom(style1.BORDER_THICK);
style1.setBorderLeft(style1.BORDER_THIN);
style1.setBorderRight(style1.BORDER_THIN);
style1.setBorderTop(style1.BORDER_THICK);
style1.setVerticalAlignment(style1.VERTICAL_CENTER);
style1.setAlignment(style1.ALIGN_JUSTIFY);
style1.setFont(font);

//  < >,  
style2 = wb.createCellStyle();
style2.setBorderBottom(style2.BORDER_THIN);
style2.setBorderLeft(style2.BORDER_THIN);
style2.setBorderRight(style2.BORDER_THIN);
style2.setBorderTop(style2.BORDER_THIN);
style2.setVerticalAlignment(style2.VERTICAL_CENTER);
style2.setAlignment(style2.ALIGN_LEFT);
style2.setFont(font);

//  < >,  
style3 = wb.createCellStyle();
style3.setBorderBottom(style3.BORDER_THIN);
style3.setBorderLeft(style3.BORDER_THIN);
style3.setBorderRight(style3.BORDER_THIN);
style3.setBorderTop(style3.BORDER_THIN);
style3.setVerticalAlignment(style3.VERTICAL_CENTER);
style3.setAlignment(style3.ALIGN_RIGHT);
style3.setFont(font);

//grid.retrieve();

row = sheet.createRow(0);
row.setHeightInPoints(40);

// 
for (i = 0, j = 0; i < grid.getColumnCount(); i ++) 
if (grid.isColumnVisible(i))
{
  // 
  logger.debug('i : ' + i);
  cell = row.createCell(j);
  title = grid.getColumnTitle(i);
  title = title.replace('<html>', '');
  title = title.replace('</html>', '');
  title = title.replace('<br>', ' ');
  cell.setCellValue(title);
  cell.setCellStyle(style1);
  j ++;
}


//  
for (i = 0; i < grid.getRowCount(); i ++)
{
   row = sheet.createRow(1 + i);
   row.setHeightInPoints(15);
   for(j = 0, k = 0; j < grid.getColumnCount(); j ++) 
   if (grid.isColumnVisible(j))
   { 
     cell = row.createCell(k++);
     //if (j == 2)
     //logger.debug('row ' + i + ' value: [' + grid.getValue(i, j) + '], type: ' + grid.getValue(i, j).getClass() );
     if (grid.getValue(i, j) != null && grid.getValue(i, j).getClass() == 'class java.lang.Double')
     {
       //if(grid.getValue(i, j).intValue() == grid.getValue(i, j))
       //  cell.setCellValue(grid.getValue(i, j).intValue());
       //else
       d = grid.getValue(i, j).doubleValue();

       //logger.debug('row ' + i + ' value: [' + d + '], type: ' + (typeof(d) != 'object')?typeof(d):d.getClass() + ', setCellType to numeric...');
       cell.setCellType(cell.CELL_TYPE_NUMERIC);
       //logger.debug('row ' + i + ' type: ' + cell.getCellType());

       cell.setCellValue(d);

       //logger.debug('row ' + i + ' type: ' + cell.getCellType());

       cell.setCellStyle(style3);
     }
     else
     {
       if (grid.getValue(i, j) != null)
       {
         cell.setCellValue(grid.getValue(i, j));
         //cell.setCellType(cell.CELL_TYPE_STRING);
         cell.setCellStyle(style2);
       }
     }
     //if (j == 2)
     //  {
     //  logger.debug('row ' + i + ' numeric value: [' + cell.getNumericCellValue() + ']');
     //  }
   }
}

//   
for (i = 0, j = 0; i < grid.getColumnCount(); i ++) 
  if (grid.isColumnVisible(i))
    sheet.autoSizeColumn(j++);

//   

wb.setPrintArea(0, 0, grid.getVisibleColumnCount() - 1, 0, grid.getRowCount());

//   

str = java.text.DateFormat.getDateTimeInstance().format(new java.util.Date);
str = str.replaceAll(':', '_');
str = str.replaceAll(' ', '_');
f = new File(java.lang.System.getProperty('java.io.tmpdir') + 'tmp_' + str + '.xls');

//  
try
{
  logger.debug('creating file ' + f.getAbsoluteFile());
  fileOut = new FileOutputStream(f.getAbsoluteFile());
  wb.write(fileOut);
  fileOut.close();
  //logger.debug('TO_PRINT_OR_NOT_TO_PRINT: ' + TO_PRINT_OR_NOT_TO_PRINT_HASH);
  //    if  (TO_PRINT_OR_NOT_TO_PRINT_HASH == 'print')
  //  	java.awt.Desktop.getDesktop().print(f);
  //else
    	java.awt.Desktop.getDesktop().open(f);
}
catch (e)
{
  logger.debug('Error creating file: ' + e);
}

//    ,  Excel ,      (   )
//logger.debug('=== deleting file ' + f);
//f['delete']();
//logger.debug('=== deleted');


ret = '';
